<?php

class FormAction extends CAction
{
	public function run()
	{
		$userFormId = $_GET['userFormId'];

		require_once('tcpdf/tcpdf.php'); 

		$userForm = FormularzUzytkownika::model()->findByPk($userFormId);
		switch($userForm->idFormularza)
		{
			case 1:
				Yii::import('application.modules.student.models.Form1');
				$model = new Form1();
			break;
			case 2:
				Yii::import('application.modules.student.models.Form2');
				$model = new Form2();
			break;
			case 3:
				Yii::import('application.modules.student.models.Form3');
				$model = new Form3();
			break;
			case 4:
				Yii::import('application.modules.student.models.Form4');
				$model = new Form4();
			break;
			case 5:
				Yii::import('application.modules.student.models.Form5');
				$model = new Form5();
			break;
			case 6:
				Yii::import('application.modules.student.models.Form6');
				$model = new Form6();
			break;
			case 7:
				Yii::import('application.modules.student.models.Form7');
				$model = new Form7();
			break;
			case 8:
				Yii::import('application.modules.student.models.Form8');
				$model = new Form8();
			break;
			case 9:
				Yii::import('application.modules.student.models.Form9');
				$model = new Form9();
			break;
			case 10:
				Yii::import('application.modules.student.models.Form10');
				$model = new Form10();
			break;
			case 11:
				Yii::import('application.modules.student.models.Form11');
				$model = new Form11();
			break;
		}
		$model->find($userForm->idUzytkownika);

		// create new PDF document
		$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

		// set document information
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetTitle('TCPDF Example 001');
		$pdf->SetSubject('TCPDF Tutorial');
		$pdf->SetKeywords('TCPDF, PDF, example, test, guide');

		// set default monospaced font
		$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

		// set margins
		$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
		$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
		$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

		// set auto page breaks
		$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

		// set image scale factor
		$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

		// set some language-dependent strings (optional)
		if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
			require_once(dirname(__FILE__).'/lang/eng.php');
			$pdf->setLanguageArray($l);
		}

		// ---------------------------------------------------------

		// set default font subsetting mode
		$pdf->setFontSubsetting(true);

		// Set font
		// dejavusans is a UTF-8 Unicode font, if you only need to
		// print standard ASCII chars, you can use core fonts like
		// helvetica or times to reduce file size.
		$pdf->SetFont('dejavusans', '', 14, '', true);
		$pdf->setPrintHeader(false);
		$pdf->setPrintFooter(false);
		// Add a page
		// This method has several options, check the source code documentation for more information.
		//$pdf->SetMargins(0, 0, 0, true);
		//$pdf->AddPage();

		// set text shadow effect
		$pdf->setTextShadow(array('enabled'=>true, 'depth_w'=>0.2, 'depth_h'=>0.2, 'color'=>array(196,196,196), 'opacity'=>1, 'blend_mode'=>'Normal'));

		//$pdf->SetXY(110, 200);

		$pdf->SetAutoPageBreak(TRUE, 0);

		foreach($model->pageUrls as $pageId=>$background)
		{
			$this->createImage('images/form-backgrounds/form'.$model->formId.'/'.$background, Yii::app()->user->id.'_'.$pageId.'_'.$userFormId.'.', $model, $pageId);
		}

		foreach($model->pageUrls as $pageId=>$background)
		{
			$pdf->AddPage();
			$pdf->Image('images/temp/'.Yii::app()->user->id.'_'.$pageId.'_'.$userFormId.'.jpg', 10, 10, $model->pageDimensions['width'], $model->pageDimensions['height'], '', '', 'T', false, 300, '', false, false, 0, false, false, false);
		}

		// Print text using writeHTMLCell()
//		$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);
		//$html = '<img src="/przedsiebiorca/images/form-backgrounds/form1/002.jpg" />';

		//$pdf->AddPage();
		//$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);
		// ---------------------------------------------------------

		// Close and output PDF document
		// This method has several options, check the source code documentation for more information.
		$pdf->Output('example_001.pdf', 'I');

		foreach($model->pageUrls as $pageId=>$background)
		{
			if(file_exists('images/temp/'.Yii::app()->user->id.'_'.$pageId.'_'.$userFormId.'.jpg'))
				unlink('images/temp/'.Yii::app()->user->id.'_'.$pageId.'_'.$userFormId.'.jpg');
		}
		//============================================================+
		// END OF FILE
		//============================================================+
	}

	public function createImage($path,$tempName,$data,$page)
	{
		if(!is_dir('images/temp'))
			mkdir('images/temp');

		// Create Image From Existing File
		$jpg_image = imagecreatefromjpeg($path);
		list($originalWidth, $originalHeight) = getimagesize($path);

		// Allocate A Color For The Text
		$black = imagecolorallocate($jpg_image, 0, 0, 0);

		$image_p = imagecreatetruecolor($data->pageDimensions['width'], $data->pageDimensions['height']);
		imagecopyresampled($image_p, $jpg_image, 0, 0, 0, 0, $data->pageDimensions['width'], $data->pageDimensions['height'], $originalWidth, $originalHeight);

		// Set Path to Font File
		$font_path = 'font.TTF';
		$fontfile="arial.ttf";
		$fontfile=realpath($fontfile);

		$pageOffset = property_exists(get_class($data), 'pageOffset') ?  $data->pageOffset : 0;

		foreach($data->pageFields[$page] as $pageFieldId)
		{
			$attribute = 'field_'.$pageFieldId;
			if(!property_exists($data,$attribute))
				continue;

			$text = $data->$attribute;
			if(isset($data->fieldReplacement) && isset($data->fieldReplacement[$pageFieldId])) {
				$text = $data->fieldReplacement[$pageFieldId][$text];
			}
			if($data->fieldType[$pageFieldId]=='checkbox')
                        {
				$text = $data->$attribute==1?'X':'';
                                //$data->fieldCoordinates[$pageFieldId]['x']-=;
                                //$data->fieldCoordinates[$pageFieldId]['y']-=;
                        }
			if ($data->fieldType[$pageFieldId] == 'textarea') {
                $textArray = explode(PHP_EOL, $data->$attribute);
                $verticalOffset = 0;
                foreach ($textArray as $row) {
                    //imagestring ( $image_p , 5 , $data->fieldCoordinates[$pageFieldId]['x'] ,$data->fieldCoordinates[$pageFieldId]['y'] -10 - ($page-1)*($data->pageDimensions['height'])+$verticalOffset - ($page-1)*$pageOffset , $row, $black );
                    imagettftext($image_p, 12, 0, $data->fieldCoordinates[$pageFieldId]['x'], $data->fieldCoordinates[$pageFieldId]['y'] - ($page - 1) * ($data->pageDimensions['height']) + $verticalOffset - ($page - 1) * $pageOffset + 6, $black, 'fonts/arial.ttf', $row);
                    $verticalOffset += 15;
                }
            } else {
                //Yii::log("!!! ".$pageFieldId." !!!");
                imagettftext($image_p, 12, 0, $data->fieldCoordinates[$pageFieldId]['x'], $data->fieldCoordinates[$pageFieldId]['y'] - ($page - 1) * ($data->pageDimensions['height']) - ($page - 1) * $pageOffset + 6, $black, 'fonts/arial.ttf', $text);
            }

            //imagestring ( $image_p , 5 , $data->fieldCoordinates[$pageFieldId]['x'] ,$data->fieldCoordinates[$pageFieldId]['y'] -10 - ($page-1)*($data->pageDimensions['height']) - ($page-1)*$pageOffset , $text, $black );
		}

		imagejpeg($image_p, 'images/temp/'.$tempName.'jpg');

		imagedestroy($jpg_image);
	}
}

?>
